<?php

/**
 * @file
 * Theme functions for the uc_cart module.
 */

/**
 * Themes the shopping cart block title.
 *
 * @param $variables
 *   An associative array containing:
 *   - title: The text to use for the title of the block.
 *   - icon_class: Class to use for the cart icon image or FALSE if the icon is
 *     disabled.
 *   - collapsible: TRUE or FALSE indicating whether or not the cart block is
 *     collapsible.
 *   - collapsed: TRUE or FALSE indicating whether or not the cart block is
 *     collapsed.
 *
 * @return string
 *   The HTML output.
 *
 * @ingroup themeable
 */

function theme_cmodule_block_content($variables) {
  $help_text = $variables['help_text'];
  $items = $variables['items'];
  $item_count = $variables['item_count'];
  $item_text = $variables['item_text'];
  $total = $variables['total'];
  $summary_links = $variables['summary_links'];
  $collapsed = $variables['collapsed'];

  $output = '';

  // Add the help text if enabled.
  if ($help_text) {
    $output .= '<span class="cart-help-text">' . $help_text . '</span>';
  }

  // Add a table of items in the cart or the empty message.

  
  if ($items) {
    $output .= '<table class="' . $class . '"><tbody>';

    // Loop through each item.
    $row_class = 'odd';
    foreach ($items as $item) {
      // Add the basic row with quantity, title, and price.
      $output .= '<tr class="' . $row_class . '">
				  <td class="cart-block-item-qty">' . $item['qty'] . '</td>'
                . '<td class="cart-block-item-title">' . $item['title'] . '</td></tr>';

      // Add a row of description if necessary.
      if ($item['desc']) {
        $output .= '<tr class="' . $row_class . '"><td colspan="3" class="cart-block-item-desc">' . $item['desc'] . '</td></tr>';
      }

      // Alternate the class for the rows.
      $row_class = ($row_class == 'odd') ? 'even' : 'odd';
    }

    $output .= '</tbody></table>';
  }
  

  // Add the summary section beneath the items table.

  // Build the basic table with the number of items in the cart and total.
  $output .= '<table class="cart-block-summary"><tbody><tr>'
           . '<td class="cart-block-summary-items">' . $item_text . '</td>'
           . '<td class="cart-block-summary-total">'.theme('links', array('links' => $summary_links)).'</td></tr>';


  $output .= '</tbody></table>';
  

  return $output;
}



/**
 * Themes the table listing the items in the shopping cart block.
 *
 * @param $variables
 *   An associative array containing:
 *   - items: An associative array of cart item information containing:
 *     - qty: Quantity in cart.
 *     - title: Item title.
 *     - price: Item price.
 *     - desc: Item description.
 *   - collapsed: TRUE or FALSE indicating whether or not the cart block is
 *     collapsed.
 *
 * @ingroup themeable
 */
